package easik.ui.menu.popup;

import java.awt.event.ActionEvent;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;
import easik.sketch.edge.SketchEdge;
import easik.sketch.vertex.EntityNode;


/** 
 * This class contains the action for the click on the popup menu to create an 
 * new injective edge. This could be boiled down a little bit in order to remove extra
 * classes (possibly combining it with the other edge adding routine)
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-07-13 Kevin Green
 */
public class NewInjectiveEdgeAction extends AbstractAction {

	/**
	 * Initialize the new menu option
	 */
	public NewInjectiveEdgeAction() {
		super("Add injective edge...");

		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Connect the two selected nodes with an edge");
	}

	/**
	 * Create an injective edge if the selection allows for it.
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e) {
		int nodeCount = 0;
		EntityNode node[] = new EntityNode[2];

		Vector currentSelection =
			Easik
				.getInstance()
				.getFrame()
				.getSketch()
				.getSelectionListener()
				.getCurrentSelection();

		if (currentSelection.size() == 2) {
			for (int i = 0; i < 2; i++) {
				node[i] = null;
				if (currentSelection.get(i) instanceof EntityNode) {
					node[i] = (EntityNode) currentSelection.get(i);
				}
			}
		}

		if ((node[0] == null) || (node[1] == null)) {
			JOptionPane.showMessageDialog(
				Easik.getInstance().getFrame(),
				"Operation must be performed with two entities selected",
				"Error",
				JOptionPane.ERROR_MESSAGE);
		} else {
			String options[] = new String[2];
			options[0] = node[0] + " to " + node[1];
			options[1] = node[1] + " to " + node[0];

			String s =
				(String) JOptionPane.showInputDialog(
					Easik.getInstance().getFrame(),
					"Select edge direction:",
					"Create Injective Edge",
					JOptionPane.QUESTION_MESSAGE,
					null,
					options,
					options[0]);
			if (s != null) {
				SketchEdge newEdge = null;
				if (s.equals(options[0])) {
					newEdge =
						new SketchEdge(
							node[0],
							node[1],
							Easik
								.getInstance()
								.getFrame()
								.getSketch()
								.getNewEdgeName(true),
							true);
				} else if (s.equals(options[1])) {
					newEdge =
						new SketchEdge(
							node[1],
							node[0],
							Easik
								.getInstance()
								.getFrame()
								.getSketch()
								.getNewEdgeName(true),
							true);
				}
				Easik.getInstance().getFrame().getSketch().addEdge(newEdge);
				Easik.getInstance().getFrame().getSketch().setDirty(true);

			}
		}

	}
}
